/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import sedona.sox.Msg;
import sedona.sox.SoxExchange;

class SoxReceiver
extends Thread {
    SoxExchange exchange;

    public void kill() {
        this.interrupt();
    }

    public void run() {
        while (!this.exchange.isClosed()) {
            try {
                Msg msg = this.exchange.receive(1000L);
                if (msg == null) continue;
                this.dispatch(msg);
            }
            catch (Exception exception) {
                if (this.exchange.closing || this.exchange.isClosed()) continue;
                exception.printStackTrace();
            }
        }
    }

    void dispatch(Msg msg) throws Exception {
        int n = msg.command();
        switch (n) {
            case 101: {
                this.dispatchEvent(msg);
                return;
            }
            case 107: {
                this.exchange.fileTransfer.receiveChunk(msg);
                return;
            }
            case 122: {
                this.exchange.fileTransfer.receiveClose(msg);
                return;
            }
        }
        this.exchange.receive(msg);
    }

    void dispatchEvent(Msg msg) {
        int n = 63;
        try {
            n = msg.u1();
            msg.u1();
            this.exchange.client.applyToCache(msg);
        }
        catch (Exception exception) {
            System.out.println("ERROR: dispatching event cmd=" + (char)n + " 0x" + Integer.toHexString(n));
            exception.printStackTrace();
        }
    }

    SoxReceiver(SoxExchange soxExchange) {
        super("SoxReceiver");
        this.exchange = soxExchange;
    }
}

